*
* Diagnostics
*
open data nile.dat
calendar 1871
data(format=free,org=columns,skips=1) 1871:1 1970:1 nile
*
nonlin sigsqeps sigsqeta
stats(noprint) nile
compute sigsqeps=.5*%variance,sigsqeta=.1*sigsqeps
*
dlm(a=1.0,c=1.0,sv=sigsqeps,sw=sigsqeta,y=nile,$
  method=bfgs,presample=diffuse,$
  vhat=vhat,svhat=svhat)
*
* Standardize the one-step prediction error (vhat).
*
set ehat = %scalar(vhat)/sqrt(%scalar(svhat))
*
@STAMPDiags(ncorrs=9) ehat
*
graph(footer="Standardized residual",vgrid=||-2.0,2.0||)
# ehat
*
* Auxiliary residuals
*
dlm(a=1.0,c=1.0,sv=sigsqeps,sw=sigsqeta,y=nile,$
  type=smooth,presample=diffuse,$
  vhat=vhat,what=what)
*
set outlier = %scalar(vhat)
diff(standardize) outlier
set break   = %scalar(what)
diff(standardize) break
spgraph(vfields=2,$
  footer="Diagnostic plots for auxiliary residuals")
graph(vgrid=||-2.0,2.0||,hlabel="Observation residual")
# outlier
graph(vgrid=||-2.0,2.0||,hlabel="State residual")
# break
spgraph(done)

